<?php

namespace Polkurier\Controller;

use Polkurier\ConfigManager;
use Polkurier\CouriersManager;
use Polkurier\Http\RedirectResponse;
use Polkurier\Http\Request;
use Polkurier\Http\Response;
use Polkurier\MapsTokenManager;
use Polkurier\PluginInfoProvider;
use Polkurier\Types\ConfigType;
use Polkurier\View;

class SettingsController
{

    /**
     * @used
     */
    public function checkUpdateAction(): RedirectResponse
    {
        (new PluginInfoProvider())
            ->clearCache()
            ->getUpdateInfo();
        return new RedirectResponse('plugins.php');
    }

    /**
     * @used
     */
    public function authorizationAction(): Response
    {
        $request = new Request();
        return new Response(View::render('settings/authorization', [
            'tab' => $request->query->getString('tab'),
        ]));
    }

    /**
     * @used
     */
    public function defaultCourierAction(): Response
    {
        $request = new Request();
        $config = new ConfigManager();

        if ($request->isPost()) {
            $config->set(ConfigType::DEFAULT_CARRIER_ID, $request->request->getString('polkurier_default_courier'));
        }

        return new Response(View::render('settings/carrier', [
            'tab' => $request->query->getString('tab'),
            'couriers' => (new CouriersManager())->getAll(),
            'defaultCourier' => $config->getString(ConfigType::DEFAULT_CARRIER_ID),
        ]));
    }

    /**
     * @used
     */
    public function couriersPointsAction(): Response
    {
        return new Response(View::render('settings/couriers_points', [
            'tab' => (new Request())->query->getString('tab'),
            'mapToken' => (new MapsTokenManager())->getToken(),
        ]));
    }

    /**
     * @used
     */
    public function defaultServicesAction(): Response
    {
        $request = new Request();
        if ($request->isPost()) {
            update_option('polkurier_default_courierservice_INSURANCE', $request->request->getString('INSURANCE') === '1' ? '1' : '');
            update_option('polkurier_default_courierservice_SMS_NOTIFICATION_RECIPIENT', $request->request->getString('SMS_NOTIFICATION_RECIPIENT') === '1' ? '1' : '');
            update_option('polkurier_default_courierservice_SMS_NOTIFICATION_RECIPIENT_WITH_NAME', $request->request->getString('SMS_NOTIFICATION_RECIPIENT_WITH_NAME') === '1' ? '1' : '');
            update_option('polkurier_default_courierservice_COVER_ADDRESS_SENDER', $request->request->getString('COVER_ADDRESS_SENDER') === '1' ? '1' : '');
            update_option('polkurier_DEFAULT_COD_TYPE', $request->request->getString('DEFAULT_COD_TYPE'));
            update_option('polkurier_DEFAULT_COD_RETURN_TYPE', $request->request->getString('DEFAULT_COD_RETURN_TYPE'));
        }
        return new Response(View::render('settings/default_services', [
            'tab' => $request->query->getString('tab'),
        ]));
    }

    /**
     * @used
     */
    public function otherAction(): Response
    {
        $request = new Request();
        $config = new ConfigManager();
        if ($request->isPost()) {
            update_option('polkurier_layout_checkout_full_row', $request->request->getString('polkurier_layout_checkout_full_row') === '1' ? '1' : '');
            update_option('polkurier_layout_checkout_point_button_position', $request->request->getString('polkurier_layout_checkout_point_button_position'));
            $config->set(ConfigType::PDF_DOWNLOAD_METHOD, $request->request->getString(ConfigType::PDF_DOWNLOAD_METHOD));
        }
        return new Response(View::render('settings/other', [
            'tab' => $request->query->getString('tab'),
            'config' => $config,
        ]));
    }

}
