<?php

namespace Polkurier;

use Polkurier\Models\CourierMessage;
use Polkurier\Util\Arr;

/**
 * @extends AbstractApiObjectManager<CourierMessage>
 */
class CourierMessageManager extends AbstractApiObjectManager
{

    protected const MODEL_CLASS = CourierMessage::class;
    protected const TRANSIENT_KEY = 'get_couriers_messages';
    protected const TRANSIENT_TTL = 900;

    private static ?array $byCourier;

    /**
     * @return CourierMessage[]
     */
    public function getByCourier(string $courierId): array
    {
        $this->load();
        return static::$byCourier[$courierId] ?? [];
    }

    protected function getModelPrimaryKeyValue($object)
    {
        return null;
    }

    protected function load(): bool
    {
        if (parent::load()) {
            self::$byCourier = Arr::groupBy($this->getDataCache('data'), 'courier');
            return true;
        }
        return false;
    }

    protected function fetchApiData(): array
    {
        return (new ApiClient())->makeApiRequest('get_couriers_messages');
    }

}
