<?php

namespace Polkurier;

use Polkurier\Models\Courier;

/**
 * @extends AbstractApiObjectManager<Courier>
 */
class CouriersManager extends AbstractApiObjectManager
{

    protected const MODEL_CLASS = Courier::class;
    protected const TRANSIENT_KEY = 'polkurier_couriers';
    protected const TRANSIENT_TTL = 900; // 15m

    protected function getModelPrimaryKeyValue($object)
    {
        return $object->servicecode;
    }

    protected function fetchApiData(): array
    {
        return (new ApiClient())->makeApiRequest('available_carriers', [
            'additional_data' => true,
        ]);
    }
}
