<?php


namespace Polkurier\Http;


use JsonSerializable;

class JsonResponse extends Response
{

    public function __construct($content = '', int $code = 200, array $headers = [])
    {
        $headers['Content-Type'] = 'application/json';
        parent::__construct($content, $code, $headers);
    }

    public function setContent($content): self
    {
        if (is_array($content) || $content instanceof JsonSerializable) {
            $content = json_encode($content);
        }
        return parent::setContent($content);
    }

}
