<?php

namespace Polkurier\Http;

use Exception;
use Polkurier\Exception\HttpException;

class PageRouter
{

    public function registerHandler(string $path, string $controllerClassName, string $controllerMethodName = 'indexAction'): PageRouter
    {
        add_action("polkurier_page_routing_$path", function () use ($controllerClassName, $controllerMethodName) {
            if (class_exists($controllerClassName)) {
                try {
                    $response = (new $controllerClassName())->$controllerMethodName();
                    if (!$response instanceof Response) {
                        throw new HttpException('Controller must return an instance of Response class', 500);
                    }
                } catch (HttpException $e) {
                    $response = new Response($e->getMessage(), $e->getCode());
                } catch (Exception $e) {
                    $response = new Response($e->getMessage(), 500);
                }
                $response->send();
            }
        });
        return $this;
    }

}
