<?php
declare(strict_types=1);

namespace Polkurier;

use Throwable;

class Logger
{

    public function exception(Throwable $e, array $context = []): void
    {
        $logger = wc_get_logger();
        if ($logger !== null) {
            $logger->critical($e->getMessage(), array_merge($e->getTrace(), $context));
        }
    }

    public function error(string $message, array $context = []): void
    {
        $logger = wc_get_logger();
        if ($logger !== null) {
            $logger->error($message, $context);
        }
    }

    public function debug(string $message, array $context = []): void
    {
        $logger = wc_get_logger();
        if ($logger !== null) {
            $logger->debug($message, $context);
        }
    }

    public function info(string $message, array $context = []): void
    {
        $logger = wc_get_logger();
        if ($logger !== null) {
            $logger->info($message, $context);
        }
    }

}
