<?php

namespace Polkurier;

use Polkurier\Exception\ApiException;

class MapsTokenManager
{

    private ?MapsToken $token = null;

    public function getToken(): MapsToken
    {
        if ($this->token === null) {
            $this->token = new MapsToken(get_option('polkurier_maps_token'));
        }
        if (!$this->token->isValid()) {
            $this->token = $this->getApiToken();
        }
        return $this->token;
    }

    public function clearToken(): MapsTokenManager
    {
        delete_option('polkurier_maps_token');
        return $this;
    }

    private function getApiToken(): MapsToken
    {
        try {
            $response = (new ApiClient())->makeApiRequest('get_map_token');
            $tokenString = null;
            if (!empty($response['token'])) {
                $tokenString = $response['token'];
            }
            $token = new MapsToken($tokenString);
            if ($token->isValid()) {
                update_option('polkurier_maps_token', $token->getToken());
            }
            return $token;
        } catch (ApiException $e) {
            return new MapsToken('');
        }
    }
}
