<?php

namespace Polkurier\Normalizer;

use Polkurier\Util\Strings;
use ReflectionClass;
use ReflectionException;

class Normalizer
{

    /**
     * @throws ReflectionException
     */
    public function normalize($object)
    {
        if ($object === null) {
            return null;
        }

        if ($object instanceof \DateTimeInterface) {
            return $object->format(DATE_ATOM);
        }

        if (is_scalar($object)) {
            return $object;
        }

        if (is_array($object)) {
            $data = [];
            foreach ($object as $key => $value) {
                $data[$key] = $this->normalize($value);
            }
            return $data;
        }

        if (is_object($object)) {
            $reflection = new ReflectionClass($object);
            $data = [];

            foreach ($reflection->getProperties() as $prop) {
                $value = null;
                $getter = 'get' . Strings::toPascalCase($prop->getName());
                $isser = 'is' . Strings::toPascalCase($prop->getName());

                if (method_exists($object, $getter)) {
                    $value = $object->$getter();
                } else if (method_exists($object, $isser)) {
                    $value = $object->$isser();
                } else {
                    $prop->setAccessible(true);
                    $value = $prop->getValue($object);
                }
                $data[$prop->getName()] = $this->normalize($value);
            }

            return $data;
        }

        return null;
    }

}
