<?php

namespace Polkurier\Order;

use Polkurier\Types\CodReturnTimeType;
use Polkurier\Types\CodReturnType;
use Polkurier\Util\Numbers;

class OrderCod
{

    public float $amount = 0.0;
    public string $returnTime = CodReturnTimeType::TYPE_ST;
    public string $returnType = CodReturnType::BA;
    public string $bankAccount = '';

    public function __construct(
        $amount = 0.0,
        $returnTime = CodReturnTimeType::TYPE_ST,
        $returnType = CodReturnType::BA,
        $bankAccount = ''
    )
    {
        $this->amount = (float)Numbers::ensureDigits($amount);
        $this->returnTime = (string)$returnTime;
        $this->returnType = (string)$returnType;
        $this->bankAccount = (string)$bankAccount;
    }

}
