<?php

namespace Polkurier\Order;

use DateTimeImmutable;
use Polkurier\Util\Dates;

class OrderPickup
{

    public ?DateTimeImmutable $date = null;
    public ?string $timeFrom = null;
    public ?string $timeTo = null;
    public bool $noCourierOrder = false;
    public bool $multiPickup = false;

    public function __construct(
        $date = null,
        ?string $timeFrom = null,
        ?string $timeTo = null,
        bool $noCourierOrder = false,
        bool $multiPickup = false
    )
    {
        $this->noCourierOrder = $noCourierOrder;
        $this->multiPickup = $multiPickup;
        if ($this->noCourierOrder) {
            $this->date = null;
            $this->timeFrom = null;
            $this->timeTo = null;
        } else {
            $this->date = Dates::dateTimeImmutableOrNull($date);
            $this->timeFrom = !empty($timeFrom) ? $timeFrom : null;
            $this->timeTo = !empty($timeTo) ? $timeTo : null;
        }
    }

}
