<?php

namespace Polkurier\ShipmentTemplate;

use JsonSerializable;
use Polkurier\Types\PackType;
use Polkurier\Types\ShipmentType;

class ShipmentTemplate implements JsonSerializable
{

    public ?string $id = null;
    public string $name = '';
    public string $courier = '';
    public float $length = 0.0;
    public float $width = 0.0;
    public float $height = 0.0;
    public float $weight = 0.0;
    public int $amount = 1;
    public bool $default = false;
    public string $type = PackType::ST;
    public string $shipment_type = ShipmentType::BOX;

    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'courier' => $this->courier,
            'length' => $this->length,
            'width' => $this->width,
            'height' => $this->height,
            'weight' => $this->weight,
            'amount' => $this->amount,
            'default' => $this->default,
            'shipment_type' => $this->shipment_type,
            'type' => $this->type,
        ];
    }

}
