<?php

namespace Polkurier\ShippingMethods;


class UpsAccessPointShippingMethodMethod extends AbstractShippingMethod
{

    protected function getDefaultTitle(): string
    {
        return 'UPS Access Point';
    }

    public function getId(): string
    {
        return 'pk_ups_access_point';
    }

    public function getPolkurierId(): string
    {
        return 'UPS_AP_COURIER_POINT';
    }

    public function isParcelPickupPoint(): bool
    {
        return true;
    }

    public function getSelectButtonLabel(): string
    {
        return __('Wybierz punkt', 'polkurier');
    }

    public function getSelectedPointLabel(): string
    {
        return __('Wybrany punkt', 'polkurier');
    }

    protected function getErrorMessages(): array
    {
        return [
            self::ERROR_MESSAGE_NOT_POINT_SELECTED => __('Nie wybrano punktu', 'polkurier'),
            self::ERROR_MESSAGE_NO_PHONE_NUMBER => __('Numer telefonu jest wymagany', 'polkurier'),
        ];
    }

}
