<?php

namespace Polkurier\Types;

final class ShipmentType
{

    public const ENVELOPE = 'envelope';
    public const BOX = 'box';
    public const PALETTE = 'palette';

    public const PACK_TYPES = [
        self::BOX => [
            PackType::ST,
            PackType::NST,
            PackType::DLU,
        ],
        self::PALETTE => [
            PackType::VP,
            PackType::PPAL,
            PackType::ST,
            PackType::PAL,
            PackType::EUR2,
            PackType::PA15,
            PackType::NST,
        ],
        self::ENVELOPE => [
            PackType::ST,
        ],
    ];

    public static function getDisplayName(string $type): string
    {
        switch ($type) {
            case self::ENVELOPE:
                return 'Koperta';
            case self::BOX:
                return 'Paczka';
            case self::PALETTE:
                return 'Paleta';
        }
        return '';
    }

}
