<?php

namespace Polkurier\Upgrade;

use Polkurier\Upgrade\Migrations\EnsureInstallationId;
use Polkurier\Upgrade\Migrations\EnsureOrderPointTable;
use Polkurier\Upgrade\Migrations\EnsureOrdersTable;
use Polkurier\Upgrade\Migrations\MigrateFrom0To1;
use Polkurier\Upgrade\Migrations\MigrateFrom10To11;
use Polkurier\Upgrade\Migrations\MigrateFrom11To12;
use Polkurier\Upgrade\Migrations\MigrateFrom1To2;
use Polkurier\Upgrade\Migrations\MigrateFrom2To3;
use Polkurier\Upgrade\Migrations\MigrateFrom3To4;
use Polkurier\Upgrade\Migrations\MigrateFrom4To5;
use Polkurier\Upgrade\Migrations\MigrateFrom5To6;
use Polkurier\Upgrade\Migrations\MigrateFrom6To7;
use Polkurier\Upgrade\Migrations\MigrateFrom7To8;
use Polkurier\Upgrade\Migrations\MigrateFrom8To9;
use Polkurier\Upgrade\Migrations\MigrateFrom9To10;

class DatabaseUpgrade
{

    private function getMigrations(): array
    {
        return [
            new EnsureInstallationId(),
            new EnsureOrdersTable(),
            new EnsureOrderPointTable(),
            new MigrateFrom0To1(),
            new MigrateFrom1To2(),
            new MigrateFrom2To3(),
            new MigrateFrom3To4(),
            new MigrateFrom4To5(),
            new MigrateFrom5To6(),
            new MigrateFrom6To7(),
            new MigrateFrom7To8(),
            new MigrateFrom8To9(),
            new MigrateFrom9To10(),
            new MigrateFrom10To11(),
            new MigrateFrom11To12(),
        ];
    }

    public function getDbVersion(): int
    {
        return (int)get_option('pk_database_version');
    }

    private function setDbVersion(int $version): void
    {
        update_option('pk_database_version', $version);
    }

    public function doUpgrade(): void
    {
        require_once(ABSPATH . '/wp-admin/includes/upgrade.php');
        foreach ($this->getMigrations() as $migration) {
            if ($migration instanceof DatabaseMigrationAlwaysInterface) {
                $migration->doUpgrade();
            } else if (
                $migration instanceof DatabaseMigrationInterface &&
                $this->getDbVersion() >= $migration->fromVersion() &&
                $this->getDbVersion() < $migration->toVersion()
            ) {
                $migration->doUpgrade();
                $this->setDbVersion($migration->toVersion());
            }
        }
    }

}
