<?php

namespace Polkurier\Upgrade\Migrations;

use Polkurier\ShipmentTemplate\ShipmentTemplate;
use Polkurier\ShipmentTemplate\ShipmentTemplateManager;
use Polkurier\Upgrade\DatabaseMigrationInterface;

class MigrateFrom7To8 implements DatabaseMigrationInterface
{

    public function fromVersion(): int
    {
        return 7;
    }

    public function toVersion(): int
    {
        return 8;
    }

    public function doUpgrade(): void
    {
        $templatesManager = new ShipmentTemplateManager();
        foreach ((array)get_option('polkurier_packages', []) as $i => $row) {
            if (is_object($row)) {
                $row = get_object_vars($row);
            }
            if (!is_array($row)) {
                continue;
            }
            $template = new ShipmentTemplate();
            $template->id = ShipmentTemplateManager::generateId();
            $template->name = (string)(isset($row['name']) ? $row['name'] : 'Bez nazwy ' . ($i + 1));
            $template->height = (float)(isset($row['height']) ? $row['height'] : 0.0);
            $template->width = (float)(isset($row['width']) ? $row['width'] : 0.0);
            $template->length = (float)(isset($row['depth']) ? $row['depth'] : 0.0);
            $template->weight = (float)(isset($row['weight']) ? $row['weight'] : 0.0);
            $template->amount = (int)(isset($row['count']) ? $row['count'] : 0);
            $template->type = isset($row['nonstandard']) && (int)$row['nonstandard'] === 1 ? 'NST' : 'ST';
            if (isset($row['type'])) {
                switch ((string)$row['type']) {
                    case "koperta":
                    case "envelope":
                        $template->shipment_type = "envelope";
                        $template->type = 'ST';
                        break;
                    case "paleta":
                    case "palette":
                        $template->shipment_type = "palette";
                        break;
                    default:
                        $template->shipment_type = 'box';
                }
            }
            $templatesManager->persist($template);
        }
        $templatesManager->save();
    }

}
