<?php

namespace Polkurier\Util;

class Database
{

    public static function createWhere(array $where): string
    {
        global $wpdb;
        $args = [];
        $query = '';
        if (!empty($where)) {
            foreach ($where as $field => $bind) {
                $query .= ' ' . str_replace('?', '%s', $field);
                if (is_array($bind)) {
                    $bind = implode(',', $bind);
                }
                if ($bind !== null) {
                    $args[] = $bind;
                }
            }
            $query = $wpdb->prepare($query, $args);
        }
        return $query;
    }

    public static function createSearchWhere(string $searchQuery, array $columns): string
    {
        global $wpdb;
        $query = '';
        $searchQuery = trim($searchQuery);
        if (!empty($searchQuery) && !empty($columns)) {
            $and = [];
            $words = array_filter(explode(' ', $searchQuery));
            $args = [];
            foreach ($words as $word) {
                $or = [];
                foreach ($columns as $column) {
                    $or[] = "{$column} LIKE %s";
                    $args[] = "%$word%";
                }
                $and[] = '(' . implode(' OR ', $or) . ')';
            }
            $query = (string)$wpdb->prepare(implode(' AND ', $and), $args);
        }
        return $query;
    }

}

