<?php


namespace Polkurier\Util;

use Polkurier\Polkurier;
use Polkurier\ShippingMethods\AbstractShippingMethod;
use WC_Order;
use WC_Order_Item_Shipping;
use WC_Shipping_Method;

class OrderTools
{

    public static function getShippingMethod(WC_Order $order): ?WC_Shipping_Method
    {
        $shippingMethods = $order->get_shipping_methods();
        if (empty($shippingMethods)) {
            return null;
        }

        /** @var WC_Order_Item_Shipping $orderShippingMethod */
        $orderShippingMethod = reset($shippingMethods);
        if ($orderShippingMethod === null || $orderShippingMethod === false) {
            return null;
        }
        return Polkurier::instance()->getShippingMethodById($orderShippingMethod->get_method_id());
    }

    public static function isOwnShippingMethod(WC_Shipping_Method $method): bool
    {
        return $method instanceof AbstractShippingMethod;
    }

}
