<?php

if (!defined('WPINC')) {
    die;
}

use Polkurier\CouriersManager;
use Polkurier\Polkurier;
use Polkurier\Types\PackType;
use Polkurier\Types\ShipmentType;
use Polkurier\Normalizer\Normalizer;

wp_enqueue_script('pk-select2', Polkurier::URL . 'admin/js/select2.min.js?ver=2.4.4', ['jquery'], Polkurier::VERSION, false);
wp_enqueue_script('pk-select2', Polkurier::URL . 'admin/js/select2.pl.js?ver=2.4.4', ['jquery'], Polkurier::VERSION, false);

if (!isset($templates)) {
    $templates = [];
}

?>

<script>
    var CARRIERS = <?php echo json_encode((new Normalizer())->normalize((new CouriersManager())->getAll())) ?>;
    var getCurrentCarrier = function () {
        var currentCourierId = jQuery('[name="polkurier_carrier_id"]:checked').val();
        for (var i = 0; i < CARRIERS.length; i++) {
            if (CARRIERS[i].servicecode === currentCourierId) {
                return CARRIERS[i];
            }
        }
        return null;
    };

    POLKURIER.shipmentTemplates = <?php echo json_encode($templates) ?>;

    POLKURIER.getShipmentTemplateById = (id) => {
        for (let template of POLKURIER.shipmentTemplates) {
            if (template.id === id) {
                return template;
            }
        }
    };

    // zarządzanie paczkami
    function fn_polkurier_validate_package() {
        var field = jQuery("#packages_list").val();
        var packages;
        var warning = false;
        if (field == '') {
            warning = true;
        } else {
            packages = JSON.parse(field);
            if (packages.length == 0) {
                warning = true;
            }
        }
        if (warning) {
            alert("Dodaj przynajmniej jedną paczkę, aby złożyć zamówienie.");
            return false;
        }

        if(jQuery('#polkurier_address option:selected').val() == undefined){
            alert("Proszę uzupełnić domyślny adres nadawcy.");
            return false;
        }

        return true;
    }

    function fn_polkurier_remove_package(index) {
        var field = jQuery("#packages_list").val();
        var packages;
        if (field != '') {
            packages = JSON.parse(field);
            packages.splice(index, 1);
            jQuery("#packages_list")
                .val(JSON.stringify(packages))
                .trigger('change');
            fn_polkurier_describe_package();
        }
        return false;
    }

    <?php
        $packTypeDescription = [];
        foreach (ShipmentType::PACK_TYPES as $shipmentType => $packTypes) {
            foreach ($packTypes as $packType) {
                $packTypeDescription[$shipmentType][$packType] = PackType::getDisplayName($packType, $shipmentType);
            }
        }
    ?>

    const PACK_TYPE_DESCRIPTION = <?php echo json_encode($packTypeDescription) ?>;

    function fn_polkurier_describe_package() {
        var msg = "<br/>";
        var dryRun = jQuery("#packages_list").data("json");
        var field = jQuery("#packages_list").val();
        var packages;
        if (field == '' && dryRun == '') {
            msg += "Brak paczek dodanych do zamówienia.";
        } else {
            if (dryRun != 0) {
                packages = dryRun; // dry run
                jQuery("#packages_list").data("json", "");
                jQuery("#packages_list").val(JSON.stringify(packages));
            } else {
                packages = JSON.parse(field);
            }
            msg += "<b>Paczki dodane do zamówienia:</b><ul>";
            var i = 0;
            var packType;
            for (i = 0; i < packages.length; i++) {
                packType = (PACK_TYPE_DESCRIPTION[packages[i].pkgtype] || {})[packages[i].type] || '';
                msg += "<li>" + packType + " (wymiary: " + packages[i].height + "x" + packages[i].width + "x" + packages[i].depth + "cm, waga: " + packages[i].weight + "kg, ilosć: " + packages[i].count;
                msg += ") ";
                msg += "<a href=\"\" onclick=\"return fn_polkurier_remove_package(" + i + ")\">usuń</a>";
                msg += " </li>"
            }
            msg += "</ul>";
        }
        jQuery("#packages_description").html(msg);
    }

    function fn_polkurier_add_package() {
        if (jQuery("#polkurier_height").val() == '' ||
            jQuery("#polkurier_width").val() == '' ||
            jQuery("#polkurier_depth").val() == '' ||
            jQuery("#polkurier_weight").val() == '' ||
            jQuery("#polkurier_count").val() == '') {
            alert("Wypełnij wszystkie pola paczki przed jej dodaniem.")
            return false;
        }
        var field = jQuery("#packages_list").val();
        var packages;
        if (field == '') {
            packages = new Array();
        } else {
            packages = JSON.parse(field);
        }
        var pkg = {
            height: jQuery("#polkurier_height").val(),
            width: jQuery("#polkurier_width").val(),
            depth: jQuery("#polkurier_depth").val(),
            weight: jQuery("#polkurier_weight").val(),
            count: jQuery("#polkurier_count").val(),
            type: jQuery("#polkurier_pack_type").val(),
            pkgtype: jQuery("input[name=polkurier_type]:checked").val(),
            nonstandard: jQuery("#polkurier_nonstandard").prop("checked")
        };
        packages.push(pkg);
        jQuery("#packages_list")
            .val(JSON.stringify(packages))
            .trigger('change');
        fn_polkurier_describe_package();
        return false;
    }

    POLKURIER.getSelectedCourier = () => jQuery('input[name="polkurier_carrier_id"]:checked').val();
    POLKURIER.setSelectedCourier = (courierId) => {
        jQuery(`input[name="polkurier_carrier_id"][value="${courierId}"]`)
            .prop('selected', true)
            .trigger('click');
    };

    POLKURIER.getOrderPacks = () => {
        const field = jQuery("#packages_list").val();
        if (!field) {
            return [];
        }
        return JSON.parse(field);
    };

    POLKURIER.setOrderPacks = (packages) => {
        jQuery("#packages_list").val(JSON.stringify(packages)).trigger('change');
    };

    POLKURIER.addPackageFromTemplate = (templateOrId) => {
        let template;
        if (typeof templateOrId === 'string') {
            template = POLKURIER.getShipmentTemplateById(templateOrId);
        } else if (typeof templateOrId === 'object') {
            template = templateOrId
        }

        if (!template) {
            return;
        }

        const packages = POLKURIER.getOrderPacks();
        packages.push({
            height: template.height,
            width: template.width,
            depth: template.length,
            weight: template.weight,
            count: template.amount,
            type: template.type,
            pkgtype: template.pkgtype,
        })
        POLKURIER.setOrderPacks(packages);
        fn_polkurier_describe_package();
    }

    if (POLKURIER.shipmentTemplates && POLKURIER.getOrderPacks().length === 0) {
        for (let template of POLKURIER.shipmentTemplates) {
            if (template.default) {
                POLKURIER.addPackageFromTemplate(template);
                if (template.courier) {
                    POLKURIER.setSelectedCourier(template.courier);
                }
                break;
            }
        }
    }

    var couriersPointsAjaxParms = function () {
        return {
            _ajax_nonce: POLKURIER.ajaxNonce,
            action: '/polkurier/pickup_points/search',
            providers: [
                jQuery('.polkurier_carrier:checked').val(),
            ],
            cod: jQuery('#polkurier_pobranie').val() > 0,
        };
    };

    var formatCourierPointOptionLabel = function (point) {
        return '[' + point.id + '] ' + point.street + ', ' + point.zip + ' ' + point.city;
    }

    var createFetchPostCodeCourierPoints = function (options) {
        options = jQuery.extend({
            providers: ['INPOST_PACZKOMAT', 'PACZKA_W_RUCHU', 'POCZTEX_PUNKT'],
            params: {},
            providersLabels: {},
            providersDefaultPoints: {},
            providersDefaultPointsLabels: {}
        }, options)
        return function () {
            var fetchParams = jQuery.extend({}, couriersPointsAjaxParms(), options.params || {});
            var defaultPoint = options.$selectEl.find('option[data-default="1"]');
            var selectedPointId = options.$selectEl.val();
            if (selectedPointId === '---' || !selectedPointId) {
                selectedPointId = null;
            }

            var provider = fetchParams.providers[0];
            var fetchOptions = {
                fetchParams: fetchParams,
                defaultPoint: defaultPoint,
                setDefault: function () {
                    var courierId = getSelectegCourierId();
                    var defaultPointId = options.providersDefaultPoints[courierId];
                    var defaultPointLabel = options.providersDefaultPointsLabels[courierId];
                    if (defaultPointId) {
                        options.$selectEl.append(new Option(
                            '[' + defaultPointId + '] ' + defaultPointLabel,
                            defaultPointId
                        ));
                        options.$selectEl.val(defaultPointId);
                        options.$selectEl.trigger('change');
                    }
                },
            };

            if (!POLKURIER.includesAny(fetchParams.providers, options.providers)) {
                options.$containerEl.hide();
                options.$containerEl.find('input, select, textarea').prop('disabled', true);
                return fetchOptions;
            }

            options.$containerEl.show();
            options.$containerEl.find('input, select, textarea').prop('disabled', false);
            options.$labelEl.text(options.providersLabels[provider] || '');

            if (!selectedPointId && !defaultPoint.length) {
                fetchOptions.setDefault();
            }
            options.$selectEl.trigger('change');

            if (options.$setDefaultButton) {
                options.$setDefaultButton.on('click', function () {
                    fetchOptions.setDefault();
                });
            }
            return fetchOptions;
        };
    };

    var getSelectegCourierId = function () {
        return jQuery('.polkurier_carrier:checked').val();
    };

    var MAP_PROVIDERS_MAP = {
        INPOST_PACZKOMAT_ALLEGRO: 'INPOST_PACZKOMAT',
        INPOST_PACZKOMAT_KURIER: 'INPOST_PACZKOMAT',
        INPOST_PACZKOMAT_ECONOMY: 'INPOST_PACZKOMAT',
        POCZTEX_KURIER_PUNKT: 'POCZTEX_PUNKT',
        POCZTEX_PUNKT_PUNKT: 'POCZTEX_PUNKT',
        FEDEX_DTR: 'FEDEX_DTR',
        DPD_POINT: 'DPD_POINT',
        DPD_COURIER_POINT: 'DPD_POINT',
        DHL_POINT: 'DHL_POINT',
        UPS_AP_POINT_POINT: 'UPS_AP_POINT_POINT',
        UPS_AP_POINT_COURIER: 'UPS_AP_POINT_POINT',
        UPS_AP_COURIER_POINT: 'UPS_AP_POINT_POINT',
    };

    var mapCouriersToMapProviders = function (providers) {
        var provider, validProviders = [];
        if (providers && providers.length > 0) {
            for (var i = 0; i < providers.length; i++) {
                provider = MAP_PROVIDERS_MAP[providers[i]] || providers[i];
                if (validProviders.indexOf(provider) === -1) {
                    validProviders.push(provider);
                }
            }
        }
        return validProviders;
    };

    var bindCourierPoint = function (options) {
        var fetchPostCodeCourierPoints = createFetchPostCodeCourierPoints(options);
        var fetchOptions = fetchPostCodeCourierPoints();
        jQuery('#polkurier_pobranie').on('change', fetchPostCodeCourierPoints);
        jQuery('.polkurier_carrier').on('change', function () {
            fetchOptions.setDefault();
            fetchOptions = fetchPostCodeCourierPoints();
        });
        options.$selectEl.select2({
            language: 'pl',
            width: 700,
            minimumInputLength: 3,
            ajax: {
                url: function (params) {
                    return POLKURIER.ajaxUrl + '?' + jQuery.param(jQuery.extend({}, fetchOptions.fetchParams, {searchQuery: params.term}));
                },
                processResults: function (data) {
                    if (data.length <= 0) {
                        return {results: []};
                    }
                    return {
                        results: data.map(function (row) {
                            return {
                                id: row.id,
                                text: formatCourierPointOptionLabel(row)
                            };
                        })
                    };
                },
                delay: 500
            }
        });

        options.$mapButtonEl.on('click', function () {
            var searchQuery = options.$selectEl.val() || '';
            if (searchQuery.length === 0) {
                searchQuery = options.defaultMapSearchQuery || '';
            }

            var functions = [];
            if (options.params.collect) {
                functions.push('collect');
            }
            if (options.params.send) {
                functions.push('send');
            }

            var params = couriersPointsAjaxParms();
            if (params.cod) {
                functions.push('cod');
            }

            var map = new POLKURIER.PointsMap({
                token: '<?php echo isset($mapToken) ? $mapToken->getToken() : '' ?>',
                providers: mapCouriersToMapProviders(params.providers),
                functions: functions,
                searchQuery: searchQuery,
            });

            map.onConfirm(function (point) {
                options.$selectEl.append(new Option(formatCourierPointOptionLabel(point), point.id));
                options.$selectEl.val(point.id);
                options.$selectEl.trigger('change');
                map.closeMapDialog();
            });
            map.showMapDialog();
        });
    };

    jQuery(document).ready(function ($) {
        // rozszerzenie list paczkomatów
        jQuery('select.select2').select2();

        bindCourierPoint({
            $selectEl: jQuery('#polkurier-sender-point'),
            $containerEl: jQuery('#polkurier-sender-point-container'),
            $labelEl: jQuery('#polkurier-sender-point-label'),
            $mapButtonEl: jQuery('#polkurier-sender-point-map-button'),
            $setDefaultButton: jQuery('#polkurier-sender-default-button'),
            providers: [
                'INPOST_PACZKOMAT',
                'INPOST_PACZKOMAT_ECONOMY',
                'INPOST_PACZKOMAT_ALLEGRO',
                'INPOST_PACZKOMAT_KURIER',
                'INPOST_INTERNATIONAL',
                'POCZTEX_PUNKT',
                'POCZTEX_PUNKT_PUNKT',
                'DPD_POINT',
                'UPS_AP_POINT_COURIER',
                'UPS_AP_POINT_POINT'
            ],
            params: {
                send: true,
                collect: false
            },
            providersLabels: {
                POCZTEX_PUNKT: 'Punkt nadania',
                POCZTEX_PUNKT_PUNKT: 'Punkt nadania',
                INPOST_PACZKOMAT: 'Paczkomat nadawcy',
                INPOST_PACZKOMAT_ALLEGRO: 'Paczkomat nadawcy',
                INPOST_PACZKOMAT_KURIER: 'Paczkomat nadawcy',
                INPOST_PACZKOMAT_ECONOMY: 'Paczkomat nadawcy',
                INPOST_INTERNATIONAL: 'Paczkomat nadawcy',
                DPD_POINT: 'Punkt nadania',
                UPS_AP_POINT_POINT: 'Punkt nadania',
                UPS_AP_POINT_COURIER: 'Punkt nadania',
            },
            providersDefaultPoints: {
                POCZTEX_PUNKT: '<?php echo get_option('polkurier_default_point_id_POCZTEX_PUNKT') ?>',
                POCZTEX_PUNKT_PUNKT: '<?php echo get_option('polkurier_default_point_id_POCZTEX_PUNKT') ?>',
                INPOST_PACZKOMAT: '<?php echo get_option('polkurier_default_point_id_INPOST_PACZKOMAT') ?>',
                INPOST_PACZKOMAT_ALLEGRO: '<?php echo get_option('polkurier_default_point_id_INPOST_PACZKOMAT') ?>',
                INPOST_PACZKOMAT_KURIER: '<?php echo get_option('polkurier_default_point_id_INPOST_PACZKOMAT') ?>',
                INPOST_PACZKOMAT_ECONOMY: '<?php echo get_option('polkurier_default_point_id_INPOST_PACZKOMAT') ?>',
                INPOST_INTERNATIONAL: '<?php echo get_option('polkurier_default_point_id_INPOST_PACZKOMAT') ?>',
                DPD_POINT: '<?php echo get_option('polkurier_default_point_id_DPD') ?>',
                UPS_AP_POINT_POINT: '<?php echo get_option('polkurier_default_point_id_UPS_AP_POINT_POINT') ?>',
                UPS_AP_POINT_COURIER: '<?php echo get_option('polkurier_default_point_id_UPS_AP_POINT_POINT') ?>',
            },
            providersDefaultPointsLabels: {
                POCZTEX_PUNKT: '<?php echo get_option('polkurier_default_point_label_POCZTEX_PUNKT') ?>',
                POCZTEX_PUNKT_PUNKT: '<?php echo get_option('polkurier_default_point_label_POCZTEX_PUNKT') ?>',
                INPOST_PACZKOMAT: '<?php echo get_option('polkurier_default_point_label_INPOST_PACZKOMAT') ?>',
                INPOST_PACZKOMAT_ALLEGRO: '<?php echo get_option('polkurier_default_point_label_INPOST_PACZKOMAT') ?>',
                INPOST_PACZKOMAT_KURIER: '<?php echo get_option('polkurier_default_point_label_INPOST_PACZKOMAT') ?>',
                INPOST_PACZKOMAT_ECONOMY: '<?php echo get_option('polkurier_default_point_label_INPOST_PACZKOMAT') ?>',
                INPOST_INTERNATIONAL: '<?php echo get_option('polkurier_default_point_label_INPOST_PACZKOMAT') ?>',
                DPD_POINT: '<?php echo get_option('polkurier_default_point_label_DPD') ?>',
                UPS_AP_POINT_POINT: '<?php echo get_option('polkurier_default_point_label_UPS_AP_POINT_POINT') ?>',
                UPS_AP_POINT_COURIER: '<?php echo get_option('polkurier_default_point_label_UPS_AP_POINT_POINT') ?>',
            }
        });

        bindCourierPoint({
            $selectEl: jQuery('#polkurier-recipient-point'),
            $containerEl: jQuery('#polkurier-recipient-point-container'),
            $labelEl: jQuery('#polkurier-recipient-point-label'),
            $mapButtonEl: jQuery('#polkurier-recipient-point-map-button'),
            providers: [
                'INPOST_PACZKOMAT',
                'INPOST_PACZKOMAT_ECONOMY',
                'INPOST_PACZKOMAT_ALLEGRO',
                'INPOST_INTERNATIONAL',
                'PACZKA_W_RUCHU',
                'POCZTEX_PUNKT_PUNKT',
                'POCZTEX_KURIER_PUNKT',
                'FEDEX_DTR', 'DPD_POINT',
                'DPD_COURIER_POINT',
                'DHL_POINT',
                'UPS_AP_POINT_POINT',
                'UPS_AP_COURIER_POINT'
            ],
            params: {
                send: false,
                collect: true
            },
            providersLabels: {
                POCZTEX_PUNKT_PUNKT: 'Punkt odbioru',
                POCZTEX_KURIER_PUNKT: 'Punkt odbioru',
                INPOST_PACZKOMAT: 'Paczkomat odbiorcy',
                INPOST_PACZKOMAT_ALLEGRO: 'Paczkomat odbiorcy',
                INPOST_PACZKOMAT_ECONOMY: 'Paczkomat odbiorcy',
                INPOST_INTERNATIONAL: 'Paczkomat odbiorcy',
                PACZKA_W_RUCHU: 'Punkt odbioru',
                FEDEX_DTR: 'Punkt odbioru',
                DPD_POINT: 'Punkt odbioru',
                DPD_COURIER_POINT: 'Punkt odbioru',
                DHL_POINT: 'Punkt odbioru',
                UPS_AP_POINT_POINT: 'Punkt odbioru',
                UPS_AP_COURIER_POINT: 'Punkt odbioru',
            },
            defaultMapSearchQuery: '<?php echo isset($order_data) ? $order_data['shipping']['postcode'] : '' ?>',
        });

        // wybór templatki
        const $polkurierTemplateSelect = jQuery("#polkurier_template_id");
        $polkurierTemplateSelect.change(function (e) {
            const templateId = $polkurierTemplateSelect.val();
            const template = POLKURIER.getShipmentTemplateById(templateId);
            $("#polkurier_height").val(template.height);
            $("#polkurier_width").val(template.width);
            $("#polkurier_depth").val(template.length);
            $("#polkurier_weight").val(template.weight);
            $("#polkurier_count").val(template.amount);
            $("#polkurier_nonstandard").prop("checked", template.nonstandard);
            $("#polkurier_pack_type").prop("checked", template.type);
            $("input[name=polkurier_type][value=" + template.shipment_type + "]").click();
        });

        $("#polkurier_date").change(function () {
            getPolkurierTimePickup();
        });

        $("select[name=polkurier_address]").change(function () {
            getPolkurierTimePickup();
        });

        $("input.polkurier_carrier").change(function () {
            getPolkurierTimePickup();
            updateCourierMessages();
        });



        function getPolkurierTimePickup(){
            $("#polkurier_pickup_date").html("Przetwarzanie...");

            POLKURIER.ajaxRequest('/polkurier/couriers/pickup_hours', {
                pickupdate: $("#polkurier_date").val(),
                courier: $("input[name=polkurier_carrier_id]:checked").val(),
                shipfrom: $("option.polkurier_address_option:checked").data("postalcode"),
                parcel: $("input[name=polkurier_type]:checked").val(),
            }).then(data => {
                if (!data.time || !Array.isArray(data.time) || data.time.length === 0) {
                    $("#polkurier_pickup_date").html('Wybrany przewoźnik nie wymaga podania godziny odbioru.');
                } else {
                    $("#polkurier_pickup_date").html(
                        $('<select>', {name: 'polkurier_pickup_date', id: 'polkurier_pickup_date_select'})
                            .append(data.time.map(time => {
                                const value = `${time.timefrom}-${time.timeto}`;
                                return $('<option>', {
                                    value: `${time.timefrom}-${time.timeto}`,
                                    text: `${time.timefrom} – ${time.timeto}`
                                });
                            }))
                    );
                }
                updatePickupSelect();
            });
        }

        var updateTemplateTypes = function () {
            var currentPackType = $('input[name="polkurier_type"]:checked').val();
            $('option.polkurier-paczka').each(function () {
                this.disabled = this.dataset.type !== currentPackType;
            });
            $('#polkurier_pack_type option').each(function () {
                this.disabled = this.dataset.type !== currentPackType;
                this.selected = false;
            });
            $(`#polkurier_pack_type option[data-type="${currentPackType}"][value="ST"]:first`).prop('selected', true);
        };

        $("input[name=polkurier_type]").change(updateTemplateTypes);
        fn_polkurier_describe_package();
        updateTemplateTypes();

        $("select[name=polkurier_address]").change(function () {
            $("#polkurier_address_radio_" + $("select[name=polkurier_address]").val()).click();
        });

        <?php if($_SERVER['REQUEST_METHOD'] == 'POST'): ?>
            getPolkurierTimePickup();
        <?php endif; ?>

        var updateCourierMessages = function () {
            var courier = getSelectegCourierId();
            jQuery('.courier-messages-container').hide();
            jQuery('#courier-' + getSelectegCourierId() + '-messages-container').show();
        };
        updateCourierMessages();

        jQuery('.courier-messages-container a').each(function () {
            this.target = '_blank';
        })
    });
</script>

<script>
    var $form = jQuery('#pk-order-form');
    var loadEvaluationRequest;
    var evaluationError = '';
    var evaluateOrder = function () {
        if (loadEvaluationRequest) {
            loadEvaluationRequest.abort();
            loadEvaluationRequest = null;
        }

        var orderData = {
            _ajax_nonce: POLKURIER.ajaxNonce,
            action: '/polkurier/orders/evaluate_v0',
        };
        $form.serializeArray().forEach(function (row) {
            orderData[row.name] = row.value;
        });
        orderData.order_id = '<?php echo (int)$_GET['order_id'] ?>';

        toggleLoadingEvaluationSpinner(true);
        loadEvaluationRequest = jQuery.ajax({
            url: POLKURIER.ajaxUrl,
            type: 'POST',
            data: orderData,
        })
            .done(function (res) {
                if (res.success) {
                    updateCouriersList(res.data);
                }
                showEvaluationError('');
            })
            .fail(function (res) {
                var error = (res && res.responseJSON && res.responseJSON.error) || 'Wystąpił błąd wyceny';
                console.log('ERROR', res);
                showEvaluationError(error);
            })
            .always(function () {
                toggleLoadingEvaluationSpinner(false);
                loadEvaluationRequest = null;
            });
        return loadEvaluationRequest;
    };

    var $loadingEvaluationSpinner;
    var toggleLoadingEvaluationSpinner = function (toggle) {
        if (toggle && !$loadingEvaluationSpinner) {
            $loadingEvaluationSpinner = jQuery('<div>', {
                class: 'polkurier-loading-evaluation-spinner polkurier-loading-evaluation-spinner--hidden',
            }).append([
                POLKURIER.createLoadingAnimation().addClass('pk-mr-2'),
                'Ładowanie wyceny'
            ]);
            jQuery('body').append($loadingEvaluationSpinner);
        }
        if ($loadingEvaluationSpinner) {
            setTimeout(function () {
                $loadingEvaluationSpinner.toggleClass('polkurier-loading-evaluation-spinner--hidden', !toggle);
            }, 0);
        }

        jQuery('#polkurier-evaluation-spinner').text(toggle ? 'Ładowanie wyceny...' : '')
    };

    var updateCouriersList = function (evaluation) {
        var $couriers = jQuery('.polkurier-courier-container');
        var evaluations = POLKURIER.indexBy(evaluation, 'servicecode');
        $couriers.each(function () {
            var $courier = jQuery(this);
            var id = $courier.data('id');
            var $courierInput = $courier.find('input')
            var $courierLabel = $courier.find('label');
            var $evaluationContainer = $courier.find('.polkurier-evaluation-container');
            var $unavailableContainer = $courier.find('.polkurier-unavailable-courier-icon');
            if ($evaluationContainer.length === 0) {
                $evaluationContainer = jQuery('<span>', {class: 'polkurier-evaluation-container'});
                $evaluationContainer.append([
                    jQuery('<span>').append([
                        jQuery('<span>', {class: 'polkurier-price-nett'}),
                        ' netto ',
                        ' (',
                        jQuery('<span>', {class: 'polkurier-price-gross'}),
                        ' brutto)',
                    ])
                ]);
                $evaluationContainer.hide();
                $courierLabel.append($evaluationContainer);
            }

            if ($unavailableContainer.length === 0) {
                $unavailableContainer = jQuery('<span>', {
                    class: 'polkurier-unavailable-courier-icon',
                    title: 'Przewoźnik niedostępny dla parametrów przesyłki'
                });
                $unavailableContainer.text('?');
                $unavailableContainer.hide();
                $courierLabel.append($unavailableContainer);
            }

            var data = evaluations[id];
            if (data) {
                if (data.conditional_price_nett > 0) {
                    $evaluationContainer
                        .find('.polkurier-price-nett')
                        .empty()
                        .append([
                            jQuery('<span>', {class: 'pk-text-danger33 pk-fw-normal'}).append([
                                Number(data.netprice).toFixed(2),
                            ]),
                            ' &rarr; ',
                            Number(data.conditional_price_nett).toFixed(2)
                        ]);

                    $evaluationContainer
                        .find('.polkurier-price-gross')
                        .empty()
                        .append([
                            jQuery('<span>', {class: 'pk-text-danger2 pk-fw-normal'}).append([
                                Number(data.grossprice).toFixed(2),
                            ]),
                            ' &rarr; ',
                            Number(data.conditional_price_gross).toFixed(2)
                        ]);
                } else {
                    $evaluationContainer.find('.polkurier-price-nett').text(Number(data.netprice).toFixed(2));
                    $evaluationContainer.find('.polkurier-price-gross').text(Number(data.grossprice).toFixed(2));
                }
                $evaluationContainer.show();
                $unavailableContainer.hide();
            } else {
                $evaluationContainer.hide();
                $unavailableContainer.show();
            }

            $courier.toggleClass('polkurier-courier-unavailable', !data);
            $courierInput
                .prop('checked', $courierInput.is(':checked') && Boolean(data))
                .prop('disabled', !data);
        });
    };

    var $evaluationErrorContainer = jQuery('#polkurier-evaluation-error');
    var showEvaluationError = error => {
        if (error !== void 0) {
            evaluationError = error;
        }
        var showError = evaluationError;
        if (showError) {
            showError = '<strong>Nie udało się wczytać wyceny przewoźników:</strong><br>' + evaluationError;
        }
        $evaluationErrorContainer.html(showError);
    };

    var evaluateFields = [
        'polkurier_type',
        'packages_list',
        'polkurier_ubezpieczenie',
        'polkurier_pobranie',
        'polkurier_pobranie_zwrot',
        'polkurier_pobranie_rodzaj',
        'polkurier_address',
        'courierservice',
        'recipient[country]',
    ];

    evaluateOrder();
    var evaluateOrderDebounced = POLKURIER.debounce(evaluateOrder, 1000);

    $form.on('change', function (e) {
        var fieldName = e.target.name.replace(/\[[\w\s\d]+]/g, '');
        if (evaluateFields.indexOf(fieldName) !== -1 || evaluateFields.indexOf(e.target.name) !== -1) {
            evaluateOrderDebounced();
        }
    });
</script>
