<?php

if (!defined('WPINC')) {
    die;
}

/** @var Request $request */

use Polkurier\Http\Request;
use Polkurier\Util\Notice;
use Polkurier\WPTables\OrdersListTable;

?>

    <h2>Lista zamówień Polkurier</h2>

<?php

if ($request->query->has('did_update_all_statuses')){
    Notice::notice('Zaktualizowano statusy zamówień');
}

if ($request->query->has('did_cancel_order')){
    Notice::notice('Anulowano zamówienie');
}
?>

<?php
    $table = new OrdersListTable();
    $table->prepare_items();
?>

<style>
    .column-address,
    .column-address_to,
    .column-label {
        width: 170px;
    }

    .column-order_number {
        width: 100px;
    }
    .column-order_number div {
        font-size: 80% !important;
    }

    td.column-address,
    td.column-address_to,
    td.column-date_send,
    td.column-status_date,
    td.column-status,
    td.column-delivered_date,
    td.column-price,
    td.column-pobranie {
        font-size: 80% !important;
    }

    .column-label ul {
        margin: 0;
        padding: 0;
        list-style: none;
    }

    .column-label li span {
        white-space: nowrap;
        background: #e0e0e0;
        padding: 2px 4px;
        border-radius: 4px;
        font-family: monospace;
        font-size: 80% !important;
    }
</style>

<form method="GET">
    <input type="hidden" name="page" value="polkurier_packages"/>
    <?php $table->search_box('Szukaj', 'pk-orders'); ?>
</form>

<form method="GET">
    <input type="hidden" name="page" value="polkurier_packages"/>
    <input type="hidden" name="action" value="label"/>
    <?php
        $table->display();
        submit_button("Generuj etykiety dla zaznaczonych", "primary", "submit", false, ['onclick' => 'return fn_polkurier_validate_labels()']);
    ?>
    <a href="admin.php?page=polkurier_packages&update_all_statuses" onclick="if (!confirm('Na pewno zaktualizować statusy? Może to potrwać kilka minut.')) {return false}" class="button button-primary">Odśwież statusy</a>
</form>

<script type="text/javascript">
    function fn_polkurier_validate_labels() {
        if (jQuery("input:checkbox:checked").length == 0)  {
            alert("Zaznacz przesyłki, dla których chcesz wygenerować etykiety.");
            return false;
        }
        else {
            return true;
        }
    }

    jQuery(document).on('click', '.pk-expand-button', function (e) {
        e.preventDefault();
        var $button = jQuery(this);
        var $container = $button.parents('.pk-expand');
        var $content = $container.find('.pk-expand-content');
        $button.hide();
        $content.slideDown();
    });
</script>
