<?php
    if (!isset($buttonLabel, $apiToken, $methodId)) {
        return;
    }
    if (!isset($selectedPointLabel)) {
        $selectedPointLabel = '';
    }
    if (!isset($selectedProvider)) {
        $selectedProvider = '';
    }
    if (!isset($providerName)) {
        $providerName = '';
    }
    if (!isset($selectedPointCod)) {
        $selectedPointCod = false;
    }
    if (!isset($selectedPointType)) {
        $selectedPointType = '';
    }
    if (!empty($providerName) && !is_array($providerName)) {
        $providerName = [$providerName];
    }
?>
<?php if (defined('DOING_AJAX') && true === DOING_AJAX): ?>
    <div class="polkurier-shippment-container">
        <button type="button" class="button alt polkurier-shippment-parcel-machine-button" id="polkurier-shipping--show-map">
            <?php echo $buttonLabel ?>
        </button>
        <script type="text/javascript">
            jQuery(document).off('click', '#polkurier-shipping--show-map');
            jQuery(document).on('click', '#polkurier-shipping--show-map', function () {
                var searchQuery = '<?php echo isset($selectedPointId) ? $selectedPointId : ''  ?>';
                if (!searchQuery) {
                    searchQuery = jQuery('#shipping_postcode').val();
                    if (!searchQuery) {
                        searchQuery = jQuery('#billing_postcode').val();
                    }
                }

                var functions = ['collect'];
                <?php if (isset($isCod) && $isCod === true): ?>
                    functions.push('cod');
                <?php endif ?>

                var country = jQuery('#billing_country').val() || jQuery('#shipping_country').val() || 'PL';
                var providers = ['<?php echo implode("', '", $providerName) ?>'];

                // InPost zagraniczny
                if (
                    country &&
                    POLKURIER.PointsMap &&
                    POLKURIER.PointsMap.getProviderInternationalSurrogates &&
                    POLKURIER.PointsMap.defaultCountry &&
                    POLKURIER.PointsMap.defaultCountry !== country
                ) {
                    providers = POLKURIER.PointsMap.getProviderInternationalSurrogates(providers);
                }

                var map = new POLKURIER.PointsMap({
                    token: '<?php echo $apiToken ?>',
                    providers: providers,
                    functions: functions,
                    searchQuery: searchQuery || '',
                });

                map.onConfirm(function (point) {
                    var label = point.street + ' \n' +
                        point.zip + ' ' + point.city +
                        (point.description ? (' \n' + point.description) : '');

                    jQuery('#polkurier_provider').val(point.provider);
                    jQuery('#polkurier_point_id').val(point.id);
                    jQuery('#polkurier_point_label').val(label);
                    jQuery('#polkurier_point_cod').val(point.cod ? 1 : 0);
                    jQuery('#polkurier_point_type').val(point.type);

                    jQuery('#polkurier-shipping-label-point-id').text(point.id);
                    jQuery('#polkurier-shipping-label-point-label').html(label.replace(/\n/g, '<br>'));
                    jQuery('#polkurier-shipping-label-container').removeClass('hidden');
                    map.closeMapDialog();
                });
                map.showMapDialog();
            });
        </script>

        <div id="polkurier-shipping-label-container" class="<?php echo empty($selectedPointId) ? 'hidden' : '' ?>">
            <div id="polkurier-shipping-label-point-id"><?php echo $selectedPointId ?></div>
            <div id="polkurier-shipping-label-point-label" class="italic"><?php echo nl2br($selectedPointLabel) ?></div>
        </div>

        <input type="hidden" id="polkurier_method_name" name="polkurier_method_name" value="<?php echo $methodId ?>"/>
        <input type="hidden" id="polkurier_provider" name="polkurier_provider" value="<?php echo $selectedProvider ?>"/>
        <input type="hidden" id="polkurier_point_cod" name="polkurier_point_cod" value="<?php echo $selectedPointCod ? '1' : '0' ?>"/>
        <input type="hidden" id="polkurier_point_id" name="polkurier_point_id" value="<?php echo $selectedPointId ?>"/>
        <input type="hidden" id="polkurier_point_label" name="polkurier_point_label" value="<?php echo $selectedPointLabel ?>"/>
        <input type="hidden" id="polkurier_point_type" name="polkurier_point_type" value="<?php echo $selectedPointType ?>"/>
    </div>
<?php endif ?>
