<?php

if (!defined('WPINC')) {
    die;
}

use Polkurier\AddressBook\Address;
use Polkurier\View;

/** @var $tab string */
/** @var Address[] $items */
/** @var Address $currentAddress */


echo View::render('settings/menu', ['tab' => $tab]);

?>
<h2>Adres nadania</h2>
<table class="wp-list-table widefat fixed striped polkurier-admin-table">
    <thead>
        <tr>
            <th>Nazwa firmy</th>
            <th>Imię i nazwisko</th>
            <th>Adres</th>
            <th>Kod pocztowy i miasto</th>
            <th>Numer telefonu</th>
            <th>E-mail</th>
            <th>Domyślny</th>
            <th>Działania</th>
        </tr>
    </thead>
    <tbody>
    <?php foreach ($items as $address): ?>
            <tr>
                <td><?php echo $address->company ?></td>
                <td><?php echo $address->person ?></td>
                <td>
                    <?php echo $address->street . ' ' . $address->housenumber . ($address->flatnumber ? " / $address->flatnumber" : '') ?>
                </td>
                <td>
                    <?php echo $address->postcode . ' ' . $address->city . ' ' . $address->country ?>
                </td>
                <td><?php echo $address->phone ?></td>
                <td><?php echo $address->email ?></td>
                <td><?php echo $address->default ? 'Tak' : '' ?></td>
                <td>
                    <a href="admin.php?page=polkurier&tab=<?php echo $tab ?>&action=edit&id=<?php echo $address->id ?>">edytuj</a>
                    <a href="admin.php?page=polkurier&tab=<?php echo $tab ?>&action=delete&id=<?php echo $address->id ?>" onclick="return confirm('Czy na pewno usunąć adres?')">usuń</a>
                </td>
            </tr>
        <?php endforeach ?>
    </tbody>
</table>


<h2><?php echo $currentAddress->id ? 'Edycja adresu' : 'Nowy adres' ?></h2>

<form action="admin.php?page=polkurier&tab=<?php echo $tab ?>" method="post">
    <input type="hidden" name="id" value="<?php echo $currentAddress->id ?>">
    <table class="form-table">
        <tbody>
        <tr>
            <th scope="row">
                <label for="polkurier_company_name">Nazwa firmy</label>
            </th>
            <td>
                <input required type="text" name="company" id="polkurier_company_name" value="<?php echo $currentAddress->company ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_name_surname">Imię&nbsp;i nazwisko</label>
            </th>
            <td>
                <input required type="text" name="person" id="polkurier_name_surname" value="<?php echo $currentAddress->person ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_street">Ulica</label>
            </th>
            <td>
                <input required type="text" name="street" id="polkurier_street" value="<?php echo $currentAddress->street ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_number_1">Numer budynku</label>
            </th>
            <td>
                <input required type="text" name="housenumber" id="polkurier_number_1" value="<?php echo $currentAddress->housenumber ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_number_2">Numer lokalu</label>
            </th>
            <td>
                <input type="text" name="flatnumber" id="polkurier_number_2" value="<?php echo $currentAddress->flatnumber ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_postal_code_cb">Kod pocztowy</label>
            </th>
            <td>
                <input
                    required
                    type="text"
                    pattern="[0-9]{2}-[0-9]{3}"
                    title="Kod pocztowy musi być w formie xx-xxx"
                    name="postcode"
                    id="polkurier_postal_code"
                    value="<?php echo $currentAddress->postcode ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_city">Miasto</label>
            </th>
            <td>
                <input required type="text" name="city" id="polkurier_city" value="<?php echo $currentAddress->city ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_phone_cb">Numer telefonu</label>
            </th>
            <td>
                <input
                    required
                    type="text"
                    pattern="[0-9]{9}"
                    title="Podaj dziewięciocyfrowy numer telefonu"
                    name="phone"
                    id="polkurier_phone"
                    value="<?php echo $currentAddress->phone ?>"
                >
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_email_cb">Adres e-mail</label>
            </th>
            <td>
                <input
                    required
                    type="email"
                    pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$"
                    title="Podaj poprawny adres e-mail"
                    name="email"
                    id="polkurier_email"
                   value="<?php echo $currentAddress->email ?>"
                >
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_default_address">Domyślny</label>
            </th>
            <td>
                <input
                    type="checkbox"
                    name="default"
                    value="1"
                    id="polkurier_default_address"
                    <?php echo $currentAddress->default ? 'checked' : '' ?>
                >
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_polkurier_account_id">ID konta Polkurier</label>
            </th>
            <td>
                <input type="text" name="account_id" id="polkurier_polkurier_account_id" value="<?php echo $currentAddress->account_id ?>">
                <br/>
                <em>
                    Opcja dostępna dla klientów nadających przesyłki za pośrednictwem
                    przewoźnika Geis oraz posiadających aktywną opcje stałych odbiorów. ID konta należy
                    pozyskać kontaktując się z biurem obsługi klienta serwisu polkurier.pl.
                </em>
            </td>
        </tr>
        </tbody>
    </table>
    <?php submit_button('Zapisz'); ?>
</form>

