<?php

if (!defined('WPINC')) {
    die;
}

/** @var string $tab */

use Polkurier\View;

echo View::render('settings/menu', ['tab' => $tab]);

?>

<form method="POST" class="pk-card pk-mt-5 pk-mx-auto pk-w-75 pk-shadow" style="background: white;">
    <div class="pk-card-header">
        Usługi domyślnie włączone
    </div>
    <div class="pk-card-body">
        <p>
            Usługi te będą automatycznie włączone w formularzu wysyłki
        </p>
        <div class="pk-my-4">
            <label>
                <input type="checkbox"
                       name="INSURANCE" <?php echo get_option('polkurier_default_courierservice_INSURANCE') === '1' ? 'checked' : '' ?>
                       value="1"/>
                <strong>Ubezpieczenie</strong>
            </label>
            <div class="pk-ml-5">
                <small>Przesyłka będzie ubezpieczona na wartość zamówienia</small>
            </div>
        </div>
        <div class="pk-my-4">
            <label>
                <input type="checkbox"
                       name="SMS_NOTIFICATION_RECIPIENT" <?php echo get_option('polkurier_default_courierservice_SMS_NOTIFICATION_RECIPIENT') === '1' ? 'checked' : '' ?>
                       value="1"/>
                <strong>Powiadomienie SMS dla odbiorcy</strong>
            </label>
            <div class="pk-ml-5">
                <small>Powiadomienie zostanie wysłane po odebraniu przesyłki od nadawcy</small>
            </div>
        </div>
        <div class="pk-my-4">
            <label>
                <input type="checkbox"
                       name="SMS_NOTIFICATION_RECIPIENT_WITH_NAME" <?php echo get_option('polkurier_default_courierservice_SMS_NOTIFICATION_RECIPIENT_WITH_NAME') === '1' ? 'checked' : '' ?>
                       value="1"/>
                <strong>Powiadomienie SMS dla odbiorcy z własną nazwą nadawcy</strong>
            </label>
            <div class="pk-ml-5">
                <small>
                    Powiadomienie zostanie wysłane po odebraniu przesyłki od nadawcy<br>
                    Jako nadawca wiadomości będzie widnieć Twoja nazwa.<br>
                    Wymagane jest ustawienie domyślnej nazwy nadawcy w panelu klienta na portalu
                    <a href="https://polkurier.pl">Polkurier.pl</a> w zakładce "Ustawienia" &rarr;
                    "Powiadomienia"
                </small>
            </div>
        </div>
        <div class="pk-my-4">
            <label>
                <input type="checkbox"
                       name="COVER_ADDRESS_SENDER" <?php echo get_option('polkurier_default_courierservice_COVER_ADDRESS_SENDER') === '1' ? 'checked' : '' ?>
                       value="1"/>
                <strong>Inny adres nadawcy na etykiecie</strong>
            </label>
            <div class="pk-ml-5">
                <small>
                    Usługa umożliwia zakrycie Twojego rzeczywistego adresu nadawczego na liście przewozowym.<br>
                    Zostanie wybrany domyślny adres z listy adresów. Adresami można zarządzać w zakładce
                    <a href="?page=polkurier&amp;tab=cover_addresses">
                        "WooCommerce" → "Ustawienia Polkurier" → "Adresy na etykiecie"
                    </a>
                </small>
            </div>
        </div>

        <hr>

        <div class="pk-my-4">
            <label>
                <div>
                    <strong>Domyślny rodzaj pobrania</strong>
                </div>
                <?php
                $DEFAULT_COD_TYPE = get_option('polkurier_DEFAULT_COD_TYPE');
                if (empty($DEFAULT_COD_TYPE)) {
                    $DEFAULT_COD_TYPE = 'S';
                }
                ?>
                <select name="DEFAULT_COD_TYPE">
                    <option value="S" <?php echo $DEFAULT_COD_TYPE === 'S' ? 'selected' : '' ?> >STANDARD –
                        Zwrot pobrania od 5 do 7 dni roboczych w zależności od przewoźnika
                    </option>
                    <option value="1D" <?php echo $DEFAULT_COD_TYPE === '1D' ? 'selected' : '' ?> >Zwrot
                        pobrania w 1 dzień roboczy od daty dostarczenia przesyłki
                    </option>
                    <option value="4D" <?php echo $DEFAULT_COD_TYPE === '4D' ? 'selected' : '' ?> >Zwrot
                        pobrania w 4 dni robocze od daty dostarczenia przesyłki
                    </option>
                    <option value="16D" <?php echo $DEFAULT_COD_TYPE === '16D' ? 'selected' : '' ?> >Zwrot w 16
                        dni roboczych od daty dostarczenia przesyłki
                    </option>
                </select>
            </label>
        </div>
        <div class="pk-my-4">
            <label>
                <div>
                    <strong>Domyślny rodzaj zwrotu pobrania</strong>
                </div>
                <?php
                $DEFAULT_COD_RETURN_TYPE = get_option('polkurier_DEFAULT_COD_RETURN_TYPE');
                if (empty($DEFAULT_COD_RETURN_TYPE)) {
                    $DEFAULT_COD_RETURN_TYPE = 'BA';
                }
                ?>
                <select name="DEFAULT_COD_RETURN_TYPE">
                    <option value="BA" <?php echo $DEFAULT_COD_RETURN_TYPE === 'BA' ? 'selected' : '' ?> >
                        Przelew na konto bankowe
                    </option>
                    <option value="PO" <?php echo $DEFAULT_COD_RETURN_TYPE === 'PO' ? 'selected' : '' ?> >
                        Przekaz pocztowy na adres nadawcy
                    </option>
                    <option value="MB" <?php echo $DEFAULT_COD_RETURN_TYPE === 'MB' ? 'selected' : '' ?> >Do
                        skarbonki
                    </option>
                </select>
            </label>
        </div>

        <div style="text-align: center" class="pk-mt-4">
            <button type="submit" class="button button-primary"
                    id="delete-default-courier-point-map-INPOST_PACZKOMAT">Zapisz
            </button>
        </div>
    </div>
</form>
<script>
    (function () {
        var $smsNotificationRecipient = jQuery('[name="SMS_NOTIFICATION_RECIPIENT"]');
        var $smsNotificationRecipientWithName = jQuery('[name="SMS_NOTIFICATION_RECIPIENT_WITH_NAME"]');
        $smsNotificationRecipient.on('change', function () {
            $smsNotificationRecipientWithName.prop('checked', false);
        });
        $smsNotificationRecipientWithName.on('change', function () {
            $smsNotificationRecipient.prop('checked', false);
        });
    })();
</script>
