<?php

if (!defined('WPINC')) {
    die;
}

use Polkurier\CouriersManager;
use Polkurier\ShipmentTemplate\ShipmentTemplate;
use Polkurier\Types\PackType;
use Polkurier\Types\ShipmentType;
use Polkurier\View;

/** @var string $tab */
/** @var CouriersManager $couriersManager */
/** @var ShipmentTemplate[] $items */
/** @var ShipmentTemplate $template */

echo View::render('settings/menu', ['tab' => $tab]);

?>

<h2>Dostępne szablony paczek</h2>
<table class="wp-list-table widefat fixed striped polkurier-admin-table">
    <thead>
    <tr>
        <th>Nazwa</th>
        <th>Rodzaj</th>
        <th>Wymiary</th>
        <th>Waga</th>
        <th>Ilość</th>
        <th>Domyślny</th>
        <th>Przewoźnik</th>
        <th>Działania</th>
    </tr>
    </thead>
    <?php foreach ($items as $item): ?>
        <tr>
            <td><?php echo $item->name ?></td>
            <td><?php echo PackType::getDisplayName($item->type, $item->shipment_type) ?></td>
            <td><?php echo $item->height . '×' . $item->width . '×' . $item->length . 'cm' ?></td>
            <td><?php echo $item->weight . 'kg' ?></td>
            <td><?php echo $item->amount ?></td>
            <td><?php echo $item->default ? 'TAK' : '' ?></td>
            <td><?php
                if (!empty($item->courier)) {
                    $courier = $couriersManager->get($item->courier);
                    if ($courier !== null) {
                        echo $courier->name;
                    } else {
                        echo $item->courier;
                    }
                } else {
                    echo '–';
                }
                ?></td>
            <td>
                <div style="display: flex; gap: 1rem;">
                    <a href="admin.php?page=polkurier&tab=templates&action=edit&id=<?php echo $item->id ?>">Edytuj</a>
                    <a href="admin.php?page=polkurier&tab=templates&action=delete&id=<?php echo $item->id ?>"
                       onclick="return confirm('Czy na pewno usunąć szablon?')">Usuń</a>
                </div>
            </td>
        </tr>
    <?php endforeach ?>
</table>


<form action="admin.php?page=polkurier&tab=templates" method="post">
    <h2><?php echo $template->id ? 'Edycja szablonu' : 'Nowy szablon' ?></h2>

    <input type="hidden" name="id" value="<?php echo $template->id ?>">
    <table class="form-table">
        <tbody>
        <tr>
            <th scope="row">
                <label for="polkurier_name">Nazwa na listę</label>
            </th>
            <td>
                <input required type="text" name="name" id="polkurier_name"
                       value="<?php echo $template->name ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_height">Wysokość (cm)</label>
            </th>
            <td>
                <input required type="number" name="height" id="polkurier_height"
                       value="<?php echo $template->height > 0 ? $template->height : '' ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_width">Szerokość (cm)</label>
            </th>
            <td>
                <input required type="number" name="width" id="polkurier_width" min="1"
                       value="<?php echo $template->width > 0 ? $template->width : '' ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_depth">Długość (cm)</label>
            </th>
            <td>
                <input required type="number" name="length" id="polkurier_depth" min="1"
                       value="<?php echo $template->length > 0 ? $template->length : '' ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_weight">Waga (kg)</label>
            </th>
            <td>
                <input required type="number" name="weight" id="polkurier_weight" min="1"
                       value="<?php echo $template->weight > 0 ? $template->weight : '' ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_count">Ilość</label>
            </th>
            <td>
                <input required type="number" name="amount" id="polkurier_count" min="1"
                       value="<?php echo $template->amount > 0 ? $template->amount : '' ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label>Typ przesyłki</label>
            </th>
            <td>
                <select name="type">
                    <?php foreach (ShipmentType::PACK_TYPES as $shipmentType => $packTypes): ?>
                        <optgroup label="<?php echo ShipmentType::getDisplayName($shipmentType) ?>">
                            <?php foreach ($packTypes as $packType): ?>
                                <option
                                        value="<?php echo $shipmentType . '::' . $packType ?>"
                                    <?php echo $template->shipment_type === $shipmentType && $template->type === $packType ? 'selected' : '' ?>
                                >
                                    <?php echo PackType::getDisplayName($packType, $shipmentType) ?>
                                </option>
                            <?php endforeach; ?>
                        </optgroup>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label>Domyślny przewoźnik</label>
            </th>
            <td>
                <select name="courier">
                    <option value="">Brak domyślnego</option>
                    <?php foreach ($couriersManager->getAll() as $courier): ?>
                        <option
                            value="<?php echo $courier->servicecode ?>"
                            <?php echo $template->courier === $courier->servicecode ? 'selected' : '' ?>
                        >
                            <?php echo $courier->name ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_default">Domyślny szablon</label>
            </th>
            <td>
                <input type="checkbox" name="default" id="polkurier_default" <?php echo $template->default ? 'checked' : '' ?>>
            </td>
        </tr>
        </tbody>
    </table>
    <?php submit_button(); ?>
</form>

